import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as Shared from "../shared.js";
import { SubscriptionsSinglePage } from "../shared.js";
export declare class Subscriptions extends APIResource {
    /**
     * Creates an account subscription.
     */
    create(params: SubscriptionCreateParams, options?: Core.RequestOptions): Core.APIPromise<SubscriptionCreateResponse>;
    /**
     * Updates an account subscription.
     */
    update(subscriptionIdentifier: string, params: SubscriptionUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SubscriptionUpdateResponse>;
    /**
     * Deletes an account's subscription.
     */
    delete(subscriptionIdentifier: string, params: SubscriptionDeleteParams, options?: Core.RequestOptions): Core.APIPromise<SubscriptionDeleteResponse>;
    /**
     * Lists all of an account's subscriptions.
     */
    get(params: SubscriptionGetParams, options?: Core.RequestOptions): Core.PagePromise<SubscriptionsSinglePage, Shared.Subscription>;
}
export type SubscriptionCreateResponse = unknown | string | null;
export type SubscriptionUpdateResponse = unknown | string | null;
export interface SubscriptionDeleteResponse {
    /**
     * Subscription identifier tag.
     */
    subscription_id?: string;
}
export interface SubscriptionCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: How often the subscription is renewed automatically.
     */
    frequency?: 'weekly' | 'monthly' | 'quarterly' | 'yearly';
    /**
     * Body param: The rate plan applied to the subscription.
     */
    rate_plan?: Shared.RatePlanParam;
}
export interface SubscriptionUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: How often the subscription is renewed automatically.
     */
    frequency?: 'weekly' | 'monthly' | 'quarterly' | 'yearly';
    /**
     * Body param: The rate plan applied to the subscription.
     */
    rate_plan?: Shared.RatePlanParam;
}
export interface SubscriptionDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface SubscriptionGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Subscriptions {
    export { type SubscriptionCreateResponse as SubscriptionCreateResponse, type SubscriptionUpdateResponse as SubscriptionUpdateResponse, type SubscriptionDeleteResponse as SubscriptionDeleteResponse, type SubscriptionCreateParams as SubscriptionCreateParams, type SubscriptionUpdateParams as SubscriptionUpdateParams, type SubscriptionDeleteParams as SubscriptionDeleteParams, type SubscriptionGetParams as SubscriptionGetParams, };
}
export { SubscriptionsSinglePage };
//# sourceMappingURL=subscriptions.d.ts.map