// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SubscriptionsSinglePage } from "../shared.mjs";
export class Subscriptions extends APIResource {
    /**
     * Creates an account subscription.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/subscriptions`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an account subscription.
     */
    update(subscriptionIdentifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/subscriptions/${subscriptionIdentifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes an account's subscription.
     */
    delete(subscriptionIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/subscriptions/${subscriptionIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all of an account's subscriptions.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/subscriptions`, SubscriptionsSinglePage, options);
    }
}
export { SubscriptionsSinglePage };
//# sourceMappingURL=subscriptions.mjs.map