// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { TokensV4PagePaginationArray } from "../../shared.mjs";
import * as PermissionGroupsAPI from "./permission-groups.mjs";
import { PermissionGroupGetResponsesSinglePage, PermissionGroupListResponsesSinglePage, PermissionGroups, } from "./permission-groups.mjs";
import * as ValueAPI from "./value.mjs";
import { Value } from "./value.mjs";
export class Tokens extends APIResource {
    constructor() {
        super(...arguments);
        this.permissionGroups = new PermissionGroupsAPI.PermissionGroups(this._client);
        this.value = new ValueAPI.Value(this._client);
    }
    /**
     * Create a new Account Owned API token.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/tokens`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing token.
     */
    update(tokenId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/tokens/${tokenId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all Account Owned API tokens created for this account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/tokens`, TokensV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Destroy an Account Owned API token.
     */
    delete(tokenId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/tokens/${tokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get information about a specific Account Owned API token.
     */
    get(tokenId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/tokens/${tokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Test whether a token works.
     */
    verify(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/tokens/verify`, options)._thenUnwrap((obj) => obj.result);
    }
}
Tokens.PermissionGroups = PermissionGroups;
Tokens.PermissionGroupListResponsesSinglePage = PermissionGroupListResponsesSinglePage;
Tokens.PermissionGroupGetResponsesSinglePage = PermissionGroupGetResponsesSinglePage;
Tokens.Value = Value;
export { TokensV4PagePaginationArray };
//# sourceMappingURL=tokens.mjs.map