import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class TotalTLS extends APIResource {
    /**
     * Set Total TLS Settings or disable the feature for a Zone.
     */
    create(params: TotalTLSCreateParams, options?: Core.RequestOptions): Core.APIPromise<TotalTLSCreateResponse>;
    /**
     * Get Total TLS Settings for a Zone.
     */
    get(params: TotalTLSGetParams, options?: Core.RequestOptions): Core.APIPromise<TotalTLSGetResponse>;
}
/**
 * The Certificate Authority that Total TLS certificates will be issued through.
 */
export type CertificateAuthority = 'google' | 'lets_encrypt' | 'ssl_com';
/**
 * The Certificate Authority that Total TLS certificates will be issued through.
 */
export type CertificateAuthorityParam = 'google' | 'lets_encrypt' | 'ssl_com';
export interface TotalTLSCreateResponse {
    /**
     * The Certificate Authority that Total TLS certificates will be issued through.
     */
    certificate_authority?: CertificateAuthority;
    /**
     * If enabled, Total TLS will order a hostname specific TLS certificate for any
     * proxied A, AAAA, or CNAME record in your zone.
     */
    enabled?: boolean;
    /**
     * The validity period in days for the certificates ordered via Total TLS.
     */
    validity_period?: 90;
}
export interface TotalTLSGetResponse {
    /**
     * The Certificate Authority that Total TLS certificates will be issued through.
     */
    certificate_authority?: CertificateAuthority;
    /**
     * If enabled, Total TLS will order a hostname specific TLS certificate for any
     * proxied A, AAAA, or CNAME record in your zone.
     */
    enabled?: boolean;
    /**
     * The validity period in days for the certificates ordered via Total TLS.
     */
    validity_period?: 90;
}
export interface TotalTLSCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: If enabled, Total TLS will order a hostname specific TLS certificate
     * for any proxied A, AAAA, or CNAME record in your zone.
     */
    enabled: boolean;
    /**
     * Body param: The Certificate Authority that Total TLS certificates will be issued
     * through.
     */
    certificate_authority?: CertificateAuthorityParam;
}
export interface TotalTLSGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace TotalTLS {
    export { type CertificateAuthority as CertificateAuthority, type TotalTLSCreateResponse as TotalTLSCreateResponse, type TotalTLSGetResponse as TotalTLSGetResponse, type TotalTLSCreateParams as TotalTLSCreateParams, type TotalTLSGetParams as TotalTLSGetParams, };
}
//# sourceMappingURL=total-tls.d.ts.map