// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class TotalTLS extends APIResource {
    /**
     * Set Total TLS Settings or disable the feature for a Zone.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/acm/total_tls`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Total TLS Settings for a Zone.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/acm/total_tls`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=total-tls.mjs.map