// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Accounts extends APIResource {
    /**
     * Add an account as a member of a particular address map.
     */
    update(addressMapId, params, options) {
        const { account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/addressing/address_maps/${addressMapId}/accounts/${account_id}`, { body: body, ...options });
    }
    /**
     * Remove an account as a member of a particular address map.
     */
    delete(addressMapId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/address_maps/${addressMapId}/accounts/${account_id}`, options);
    }
}
//# sourceMappingURL=accounts.mjs.map