// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as AccountsAPI from "./accounts.mjs";
import { Accounts, } from "./accounts.mjs";
import * as IPsAPI from "./ips.mjs";
import { IPs } from "./ips.mjs";
import * as ZonesAPI from "./zones.mjs";
import { Zones } from "./zones.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class AddressMaps extends APIResource {
    constructor() {
        super(...arguments);
        this.accounts = new AccountsAPI.Accounts(this._client);
        this.ips = new IPsAPI.IPs(this._client);
        this.zones = new ZonesAPI.Zones(this._client);
    }
    /**
     * Create a new address map under the account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/address_maps`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all address maps owned by the account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/addressing/address_maps`, AddressMapsSinglePage, options);
    }
    /**
     * Delete a particular address map owned by the account. An Address Map must be
     * disabled before it can be deleted.
     */
    delete(addressMapId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/address_maps/${addressMapId}`, options);
    }
    /**
     * Modify properties of an address map owned by the account.
     */
    edit(addressMapId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/addressing/address_maps/${addressMapId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Show a particular address map owned by the account.
     */
    get(addressMapId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/addressing/address_maps/${addressMapId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class AddressMapsSinglePage extends SinglePage {
}
AddressMaps.AddressMapsSinglePage = AddressMapsSinglePage;
AddressMaps.Accounts = Accounts;
AddressMaps.IPs = IPs;
AddressMaps.Zones = Zones;
//# sourceMappingURL=address-maps.mjs.map