import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as Shared from "../../shared.js";
export declare class IPs extends APIResource {
    /**
     * Add an IP from a prefix owned by the account to a particular address map.
     */
    update(addressMapId: string, ipAddress: string, params: IPUpdateParams, options?: Core.RequestOptions): Core.APIPromise<IPUpdateResponse>;
    /**
     * Remove an IP from a particular address map.
     */
    delete(addressMapId: string, ipAddress: string, params: IPDeleteParams, options?: Core.RequestOptions): Core.APIPromise<IPDeleteResponse>;
}
export interface IPUpdateResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
    result_info?: IPUpdateResponse.ResultInfo;
}
export declare namespace IPUpdateResponse {
    interface ResultInfo {
        /**
         * Total number of results for the requested service
         */
        count?: number;
        /**
         * Current page within paginated list of results
         */
        page?: number;
        /**
         * Number of results per page of results
         */
        per_page?: number;
        /**
         * Total results available without any search parameters
         */
        total_count?: number;
    }
}
export interface IPDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
    result_info?: IPDeleteResponse.ResultInfo;
}
export declare namespace IPDeleteResponse {
    interface ResultInfo {
        /**
         * Total number of results for the requested service
         */
        count?: number;
        /**
         * Current page within paginated list of results
         */
        page?: number;
        /**
         * Number of results per page of results
         */
        per_page?: number;
        /**
         * Total results available without any search parameters
         */
        total_count?: number;
    }
}
export interface IPUpdateParams {
    /**
     * Path param: Identifier of a Cloudflare account.
     */
    account_id: string;
    /**
     * Body param:
     */
    body: unknown;
}
export interface IPDeleteParams {
    /**
     * Identifier of a Cloudflare account.
     */
    account_id: string;
}
export declare namespace IPs {
    export { type IPUpdateResponse as IPUpdateResponse, type IPDeleteResponse as IPDeleteResponse, type IPUpdateParams as IPUpdateParams, type IPDeleteParams as IPDeleteParams, };
}
//# sourceMappingURL=ips.d.ts.map