// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class IPs extends APIResource {
    /**
     * Add an IP from a prefix owned by the account to a particular address map.
     */
    update(addressMapId, ipAddress, params, options) {
        const { account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/addressing/address_maps/${addressMapId}/ips/${ipAddress}`, { body: body, ...options });
    }
    /**
     * Remove an IP from a particular address map.
     */
    delete(addressMapId, ipAddress, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/address_maps/${addressMapId}/ips/${ipAddress}`, options);
    }
}
//# sourceMappingURL=ips.mjs.map