import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as Shared from "../../shared.js";
export declare class Zones extends APIResource {
    /**
     * Add a zone as a member of a particular address map.
     */
    update(addressMapId: string, params: ZoneUpdateParams, options?: Core.RequestOptions): Core.APIPromise<ZoneUpdateResponse>;
    /**
     * Remove a zone as a member of a particular address map.
     */
    delete(addressMapId: string, params: ZoneDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ZoneDeleteResponse>;
}
export interface ZoneUpdateResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
    result_info?: ZoneUpdateResponse.ResultInfo;
}
export declare namespace ZoneUpdateResponse {
    interface ResultInfo {
        /**
         * Total number of results for the requested service
         */
        count?: number;
        /**
         * Current page within paginated list of results
         */
        page?: number;
        /**
         * Number of results per page of results
         */
        per_page?: number;
        /**
         * Total results available without any search parameters
         */
        total_count?: number;
    }
}
export interface ZoneDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
    result_info?: ZoneDeleteResponse.ResultInfo;
}
export declare namespace ZoneDeleteResponse {
    interface ResultInfo {
        /**
         * Total number of results for the requested service
         */
        count?: number;
        /**
         * Current page within paginated list of results
         */
        page?: number;
        /**
         * Number of results per page of results
         */
        per_page?: number;
        /**
         * Total results available without any search parameters
         */
        total_count?: number;
    }
}
export interface ZoneUpdateParams {
    /**
     * Path param: Identifier of a zone.
     */
    zone_id: string;
    /**
     * Path param: Identifier of a Cloudflare account.
     */
    account_id: string;
    /**
     * Body param:
     */
    body: unknown;
}
export interface ZoneDeleteParams {
    /**
     * Identifier of a zone.
     */
    zone_id: string;
    /**
     * Identifier of a Cloudflare account.
     */
    account_id: string;
}
export declare namespace Zones {
    export { type ZoneUpdateResponse as ZoneUpdateResponse, type ZoneDeleteResponse as ZoneDeleteResponse, type ZoneUpdateParams as ZoneUpdateParams, type ZoneDeleteParams as ZoneDeleteParams, };
}
//# sourceMappingURL=zones.d.ts.map