"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Zones = void 0;
const resource_1 = require("../../../resource.js");
class Zones extends resource_1.APIResource {
    /**
     * Add a zone as a member of a particular address map.
     */
    update(addressMapId, params, options) {
        const { zone_id, account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/addressing/address_maps/${addressMapId}/zones/${zone_id}`, { body: body, ...options });
    }
    /**
     * Remove a zone as a member of a particular address map.
     */
    delete(addressMapId, params, options) {
        const { zone_id, account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/address_maps/${addressMapId}/zones/${zone_id}`, options);
    }
}
exports.Zones = Zones;
//# sourceMappingURL=zones.js.map