// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as Core from "../../core.mjs";
export class LOADocuments extends APIResource {
    /**
     * Submit LOA document (pdf format) under the account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/loa_documents`, Core.multipartFormRequestOptions({ body, ...options }))._thenUnwrap((obj) => obj.result);
    }
    /**
     * Download specified LOA document under the account.
     */
    get(loaDocumentId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/addressing/loa_documents/${loaDocumentId}/download`, {
            ...options,
            headers: { Accept: 'application/pdf', ...options?.headers },
            __binaryResponse: true,
        });
    }
}
//# sourceMappingURL=loa-documents.mjs.map