"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BGPPrefixesSinglePage = exports.BGPPrefixes = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class BGPPrefixes extends resource_1.APIResource {
    /**
     * Create a BGP prefix, controlling the BGP advertisement status of a specific
     * subnet. When created, BGP prefixes are initially withdrawn, and can be
     * advertised with the Update BGP Prefix API.
     */
    create(prefixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bgp/prefixes`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all BGP Prefixes within the specified IP Prefix. BGP Prefixes are used to
     * control which specific subnets are advertised to the Internet. It is possible to
     * advertise subnets more specific than an IP Prefix by creating more specific BGP
     * Prefixes.
     */
    list(prefixId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bgp/prefixes`, BGPPrefixesSinglePage, options);
    }
    /**
     * Update the properties of a BGP Prefix, such as the on demand advertisement
     * status (advertised or withdrawn).
     */
    edit(prefixId, bgpPrefixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bgp/prefixes/${bgpPrefixId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieve a single BGP Prefix according to its identifier
     */
    get(prefixId, bgpPrefixId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bgp/prefixes/${bgpPrefixId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.BGPPrefixes = BGPPrefixes;
class BGPPrefixesSinglePage extends pagination_1.SinglePage {
}
exports.BGPPrefixesSinglePage = BGPPrefixesSinglePage;
BGPPrefixes.BGPPrefixesSinglePage = BGPPrefixesSinglePage;
//# sourceMappingURL=bgp-prefixes.js.map