import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class Delegations extends APIResource {
    /**
     * Create a new account delegation for a given IP prefix.
     */
    create(prefixId: string, params: DelegationCreateParams, options?: Core.RequestOptions): Core.APIPromise<Delegations>;
    /**
     * List all delegations for a given account IP prefix.
     */
    list(prefixId: string, params: DelegationListParams, options?: Core.RequestOptions): Core.PagePromise<DelegationsSinglePage, Delegations>;
    /**
     * Delete an account delegation for a given IP prefix.
     */
    delete(prefixId: string, delegationId: string, params: DelegationDeleteParams, options?: Core.RequestOptions): Core.APIPromise<DelegationDeleteResponse>;
}
export declare class DelegationsSinglePage extends SinglePage<Delegations> {
}
export interface Delegations {
    /**
     * Identifier of a Delegation.
     */
    id?: string;
    /**
     * IP Prefix in Classless Inter-Domain Routing format.
     */
    cidr?: string;
    created_at?: string;
    /**
     * Account identifier for the account to which prefix is being delegated.
     */
    delegated_account_id?: string;
    modified_at?: string;
    /**
     * Identifier of an IP Prefix.
     */
    parent_prefix_id?: string;
}
export interface DelegationDeleteResponse {
    /**
     * Identifier of a Delegation.
     */
    id?: string;
}
export interface DelegationCreateParams {
    /**
     * Path param: Identifier of a Cloudflare account.
     */
    account_id: string;
    /**
     * Body param: IP Prefix in Classless Inter-Domain Routing format.
     */
    cidr: string;
    /**
     * Body param: Account identifier for the account to which prefix is being
     * delegated.
     */
    delegated_account_id: string;
}
export interface DelegationListParams {
    /**
     * Identifier of a Cloudflare account.
     */
    account_id: string;
}
export interface DelegationDeleteParams {
    /**
     * Identifier of a Cloudflare account.
     */
    account_id: string;
}
export declare namespace Delegations {
    export { type Delegations as Delegations, type DelegationDeleteResponse as DelegationDeleteResponse, DelegationsSinglePage as DelegationsSinglePage, type DelegationCreateParams as DelegationCreateParams, type DelegationListParams as DelegationListParams, type DelegationDeleteParams as DelegationDeleteParams, };
}
//# sourceMappingURL=delegations.d.ts.map