"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegationsSinglePage = exports.Delegations = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Delegations extends resource_1.APIResource {
    /**
     * Create a new account delegation for a given IP prefix.
     */
    create(prefixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/prefixes/${prefixId}/delegations`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all delegations for a given account IP prefix.
     */
    list(prefixId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/addressing/prefixes/${prefixId}/delegations`, DelegationsSinglePage, options);
    }
    /**
     * Delete an account delegation for a given IP prefix.
     */
    delete(prefixId, delegationId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/prefixes/${prefixId}/delegations/${delegationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Delegations = Delegations;
class DelegationsSinglePage extends pagination_1.SinglePage {
}
exports.DelegationsSinglePage = DelegationsSinglePage;
Delegations.DelegationsSinglePage = DelegationsSinglePage;
//# sourceMappingURL=delegations.js.map