// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Delegations extends APIResource {
    /**
     * Create a new account delegation for a given IP prefix.
     */
    create(prefixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/prefixes/${prefixId}/delegations`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all delegations for a given account IP prefix.
     */
    list(prefixId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/addressing/prefixes/${prefixId}/delegations`, DelegationsSinglePage, options);
    }
    /**
     * Delete an account delegation for a given IP prefix.
     */
    delete(prefixId, delegationId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/prefixes/${prefixId}/delegations/${delegationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DelegationsSinglePage extends SinglePage {
}
Delegations.DelegationsSinglePage = DelegationsSinglePage;
//# sourceMappingURL=delegations.mjs.map