// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as AdvertisementStatusAPI from "./advertisement-status.mjs";
import { AdvertisementStatus, } from "./advertisement-status.mjs";
import * as BGPPrefixesAPI from "./bgp-prefixes.mjs";
import { BGPPrefixes, BGPPrefixesSinglePage, } from "./bgp-prefixes.mjs";
import * as DelegationsAPI from "./delegations.mjs";
import { DelegationsSinglePage, } from "./delegations.mjs";
import * as ServiceBindingsAPI from "./service-bindings.mjs";
import { ServiceBindings, ServiceBindingsSinglePage, } from "./service-bindings.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Prefixes extends APIResource {
    constructor() {
        super(...arguments);
        this.serviceBindings = new ServiceBindingsAPI.ServiceBindings(this._client);
        this.bgpPrefixes = new BGPPrefixesAPI.BGPPrefixes(this._client);
        this.advertisementStatus = new AdvertisementStatusAPI.AdvertisementStatus(this._client);
        this.delegations = new DelegationsAPI.Delegations(this._client);
    }
    /**
     * Add a new prefix under the account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/prefixes`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all prefixes owned by the account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/addressing/prefixes`, PrefixesSinglePage, options);
    }
    /**
     * Delete an unapproved prefix owned by the account.
     */
    delete(prefixId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/prefixes/${prefixId}`, options);
    }
    /**
     * Modify the description for a prefix owned by the account.
     */
    edit(prefixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/addressing/prefixes/${prefixId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List a particular prefix owned by the account.
     */
    get(prefixId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/addressing/prefixes/${prefixId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class PrefixesSinglePage extends SinglePage {
}
Prefixes.PrefixesSinglePage = PrefixesSinglePage;
Prefixes.ServiceBindings = ServiceBindings;
Prefixes.ServiceBindingsSinglePage = ServiceBindingsSinglePage;
Prefixes.BGPPrefixes = BGPPrefixes;
Prefixes.BGPPrefixesSinglePage = BGPPrefixesSinglePage;
Prefixes.AdvertisementStatus = AdvertisementStatus;
Prefixes.DelegationsSinglePage = DelegationsSinglePage;
//# sourceMappingURL=prefixes.mjs.map