// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class ServiceBindings extends APIResource {
    /**
     * Creates a new Service Binding, routing traffic to IPs within the given CIDR to a
     * service running on Cloudflare's network. **Note:** This API may only be used on
     * prefixes currently configured with a Magic Transit service binding, and only
     * allows creating service bindings for the Cloudflare CDN or Cloudflare Spectrum.
     */
    create(prefixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bindings`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List the Cloudflare services this prefix is currently bound to. Traffic sent to
     * an address within an IP prefix will be routed to the Cloudflare service of the
     * most-specific Service Binding matching the address. **Example:** binding
     * `192.0.2.0/24` to Cloudflare Magic Transit and `192.0.2.1/32` to the Cloudflare
     * CDN would route traffic for `192.0.2.1` to the CDN, and traffic for all other
     * IPs in the prefix to Cloudflare Magic Transit.
     */
    list(prefixId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bindings`, ServiceBindingsSinglePage, options);
    }
    /**
     * Delete a Service Binding
     */
    delete(prefixId, bindingId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bindings/${bindingId}`, options);
    }
    /**
     * Fetch a single Service Binding
     */
    get(prefixId, bindingId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/addressing/prefixes/${prefixId}/bindings/${bindingId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ServiceBindingsSinglePage extends SinglePage {
}
ServiceBindings.ServiceBindingsSinglePage = ServiceBindingsSinglePage;
//# sourceMappingURL=service-bindings.mjs.map