// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as RegionsAPI from "./regions.mjs";
import { RegionListResponsesSinglePage, Regions } from "./regions.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class RegionalHostnames extends APIResource {
    constructor() {
        super(...arguments);
        this.regions = new RegionsAPI.Regions(this._client);
    }
    /**
     * Create a new Regional Hostname entry. Cloudflare will only use data centers that
     * are physically located within the chosen region to decrypt and service HTTPS
     * traffic. Learn more about
     * [Regional Services](https://developers.cloudflare.com/data-localization/regional-services/get-started/).
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/addressing/regional_hostnames`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all Regional Hostnames within a zone.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/addressing/regional_hostnames`, RegionalHostnameListResponsesSinglePage, options);
    }
    /**
     * Delete the region configuration for a specific Regional Hostname.
     */
    delete(hostname, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/addressing/regional_hostnames/${hostname}`, options);
    }
    /**
     * Update the configuration for a specific Regional Hostname. Only the region_key
     * of a hostname is mutable.
     */
    edit(hostname, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/addressing/regional_hostnames/${hostname}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch the configuration for a specific Regional Hostname, within a zone.
     */
    get(hostname, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/addressing/regional_hostnames/${hostname}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class RegionalHostnameListResponsesSinglePage extends SinglePage {
}
RegionalHostnames.RegionalHostnameListResponsesSinglePage = RegionalHostnameListResponsesSinglePage;
RegionalHostnames.Regions = Regions;
RegionalHostnames.RegionListResponsesSinglePage = RegionListResponsesSinglePage;
//# sourceMappingURL=regional-hostnames.mjs.map