// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as DatasetsAPI from "./datasets.mjs";
import { DatasetListResponsesV4PagePaginationArray, Datasets, } from "./datasets.mjs";
import * as EvaluationTypesAPI from "./evaluation-types.mjs";
import { EvaluationTypeListResponsesV4PagePaginationArray, EvaluationTypes, } from "./evaluation-types.mjs";
import * as EvaluationsAPI from "./evaluations.mjs";
import { EvaluationListResponsesV4PagePaginationArray, Evaluations, } from "./evaluations.mjs";
import * as LogsAPI from "./logs.mjs";
import { LogListResponsesV4PagePaginationArray, Logs, } from "./logs.mjs";
import * as URLsAPI from "./urls.mjs";
import { URLs } from "./urls.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class AIGateway extends APIResource {
    constructor() {
        super(...arguments);
        this.evaluationTypes = new EvaluationTypesAPI.EvaluationTypes(this._client);
        this.logs = new LogsAPI.Logs(this._client);
        this.datasets = new DatasetsAPI.Datasets(this._client);
        this.evaluations = new EvaluationsAPI.Evaluations(this._client);
        this.urls = new URLsAPI.URLs(this._client);
    }
    /**
     * Create a new Gateway
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/ai-gateway/gateways`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Gateway
     */
    update(id, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/ai-gateway/gateways/${id}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Gateways
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/ai-gateway/gateways`, AIGatewayListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a Gateway
     */
    delete(id, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/ai-gateway/gateways/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a Gateway
     */
    get(id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class AIGatewayListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
AIGateway.EvaluationTypes = EvaluationTypes;
AIGateway.EvaluationTypeListResponsesV4PagePaginationArray = EvaluationTypeListResponsesV4PagePaginationArray;
AIGateway.Logs = Logs;
AIGateway.LogListResponsesV4PagePaginationArray = LogListResponsesV4PagePaginationArray;
AIGateway.Datasets = Datasets;
AIGateway.DatasetListResponsesV4PagePaginationArray = DatasetListResponsesV4PagePaginationArray;
AIGateway.Evaluations = Evaluations;
AIGateway.EvaluationListResponsesV4PagePaginationArray = EvaluationListResponsesV4PagePaginationArray;
AIGateway.URLs = URLs;
//# sourceMappingURL=ai-gateway.mjs.map