"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatasetListResponsesV4PagePaginationArray = exports.Datasets = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Datasets extends resource_1.APIResource {
    /**
     * Create a new Dataset
     */
    create(gatewayId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Dataset
     */
    update(gatewayId, id, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets/${id}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Datasets
     */
    list(gatewayId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets`, DatasetListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a Dataset
     */
    delete(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a Dataset
     */
    get(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Datasets = Datasets;
class DatasetListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.DatasetListResponsesV4PagePaginationArray = DatasetListResponsesV4PagePaginationArray;
Datasets.DatasetListResponsesV4PagePaginationArray = DatasetListResponsesV4PagePaginationArray;
//# sourceMappingURL=datasets.js.map