// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class Datasets extends APIResource {
    /**
     * Create a new Dataset
     */
    create(gatewayId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Dataset
     */
    update(gatewayId, id, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets/${id}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Datasets
     */
    list(gatewayId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets`, DatasetListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a Dataset
     */
    delete(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a Dataset
     */
    get(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/datasets/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DatasetListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
Datasets.DatasetListResponsesV4PagePaginationArray = DatasetListResponsesV4PagePaginationArray;
//# sourceMappingURL=datasets.mjs.map