"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluationListResponsesV4PagePaginationArray = exports.Evaluations = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Evaluations extends resource_1.APIResource {
    /**
     * Create a new Evaluation
     */
    create(gatewayId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/evaluations`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Evaluations
     */
    list(gatewayId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/evaluations`, EvaluationListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a Evaluation
     */
    delete(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/evaluations/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a Evaluation
     */
    get(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/evaluations/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Evaluations = Evaluations;
class EvaluationListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.EvaluationListResponsesV4PagePaginationArray = EvaluationListResponsesV4PagePaginationArray;
Evaluations.EvaluationListResponsesV4PagePaginationArray = EvaluationListResponsesV4PagePaginationArray;
//# sourceMappingURL=evaluations.js.map