"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogListResponsesV4PagePaginationArray = exports.Logs = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Logs extends resource_1.APIResource {
    /**
     * List Gateway Logs
     */
    list(gatewayId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/logs`, LogListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete Gateway Logs
     */
    delete(gatewayId, params, options) {
        const { account_id, filters, limit, order_by, order_by_direction } = params;
        return this._client.delete(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/logs`, {
            query: { filters, limit, order_by, order_by_direction },
            ...options,
        });
    }
    /**
     * Patch Gateway Log
     */
    edit(gatewayId, id, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/logs/${id}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Gateway Log Detail
     */
    get(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/logs/${id}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Gateway Log Request
     */
    request(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/logs/${id}/request`, options);
    }
    /**
     * Get Gateway Log Response
     */
    response(gatewayId, id, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/ai-gateway/gateways/${gatewayId}/logs/${id}/response`, options);
    }
}
exports.Logs = Logs;
class LogListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.LogListResponsesV4PagePaginationArray = LogListResponsesV4PagePaginationArray;
Logs.LogListResponsesV4PagePaginationArray = LogListResponsesV4PagePaginationArray;
//# sourceMappingURL=logs.js.map