"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AI = void 0;
const resource_1 = require("../../resource.js");
const AuthorsAPI = __importStar(require("./authors.js"));
const authors_1 = require("./authors.js");
const TasksAPI = __importStar(require("./tasks.js"));
const tasks_1 = require("./tasks.js");
const FinetunesAPI = __importStar(require("./finetunes/finetunes.js"));
const finetunes_1 = require("./finetunes/finetunes.js");
const ModelsAPI = __importStar(require("./models/models.js"));
const models_1 = require("./models/models.js");
class AI extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.finetunes = new FinetunesAPI.Finetunes(this._client);
        this.authors = new AuthorsAPI.Authors(this._client);
        this.tasks = new TasksAPI.Tasks(this._client);
        this.models = new ModelsAPI.Models(this._client);
    }
    /**
     * This endpoint provides users with the capability to run specific AI models
     * on-demand.
     *
     * By submitting the required input data, users can receive real-time predictions
     * or results generated by the chosen AI model. The endpoint supports various AI
     * model types, ensuring flexibility and adaptability for diverse use cases.
     *
     * Model specific inputs available in
     * [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).
     */
    run(modelName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/ai/run/${modelName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.AI = AI;
AI.Finetunes = finetunes_1.Finetunes;
AI.Authors = authors_1.Authors;
AI.AuthorListResponsesSinglePage = authors_1.AuthorListResponsesSinglePage;
AI.Tasks = tasks_1.Tasks;
AI.TaskListResponsesSinglePage = tasks_1.TaskListResponsesSinglePage;
AI.Models = models_1.Models;
AI.ModelListResponsesV4PagePaginationArray = models_1.ModelListResponsesV4PagePaginationArray;
//# sourceMappingURL=ai.js.map