// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as AuthorsAPI from "./authors.mjs";
import { AuthorListResponsesSinglePage, Authors } from "./authors.mjs";
import * as TasksAPI from "./tasks.mjs";
import { TaskListResponsesSinglePage, Tasks } from "./tasks.mjs";
import * as FinetunesAPI from "./finetunes/finetunes.mjs";
import { Finetunes, } from "./finetunes/finetunes.mjs";
import * as ModelsAPI from "./models/models.mjs";
import { ModelListResponsesV4PagePaginationArray, Models, } from "./models/models.mjs";
export class AI extends APIResource {
    constructor() {
        super(...arguments);
        this.finetunes = new FinetunesAPI.Finetunes(this._client);
        this.authors = new AuthorsAPI.Authors(this._client);
        this.tasks = new TasksAPI.Tasks(this._client);
        this.models = new ModelsAPI.Models(this._client);
    }
    /**
     * This endpoint provides users with the capability to run specific AI models
     * on-demand.
     *
     * By submitting the required input data, users can receive real-time predictions
     * or results generated by the chosen AI model. The endpoint supports various AI
     * model types, ensuring flexibility and adaptability for diverse use cases.
     *
     * Model specific inputs available in
     * [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).
     */
    run(modelName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/ai/run/${modelName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
AI.Finetunes = Finetunes;
AI.Authors = Authors;
AI.AuthorListResponsesSinglePage = AuthorListResponsesSinglePage;
AI.Tasks = Tasks;
AI.TaskListResponsesSinglePage = TaskListResponsesSinglePage;
AI.Models = Models;
AI.ModelListResponsesV4PagePaginationArray = ModelListResponsesV4PagePaginationArray;
//# sourceMappingURL=ai.mjs.map