"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.PagerdutiesSinglePage = exports.PagerdutyResource = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class PagerdutyResource extends resource_1.APIResource {
    /**
     * Creates a new token for integrating with PagerDuty.
     */
    create(params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/alerting/v3/destinations/pagerduty/connect`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes all the PagerDuty Services connected to the account.
     */
    delete(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/alerting/v3/destinations/pagerduty`, options);
    }
    /**
     * Get a list of all configured PagerDuty services.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/alerting/v3/destinations/pagerduty`, PagerdutiesSinglePage, options);
    }
    /**
     * Links PagerDuty with the account using the integration token.
     */
    link(tokenId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/alerting/v3/destinations/pagerduty/connect/${tokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.PagerdutyResource = PagerdutyResource;
class PagerdutiesSinglePage extends pagination_1.SinglePage {
}
exports.PagerdutiesSinglePage = PagerdutiesSinglePage;
PagerdutyResource.PagerdutiesSinglePage = PagerdutiesSinglePage;
//# sourceMappingURL=pagerduty.js.map