// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class PagerdutyResource extends APIResource {
    /**
     * Creates a new token for integrating with PagerDuty.
     */
    create(params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/alerting/v3/destinations/pagerduty/connect`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes all the PagerDuty Services connected to the account.
     */
    delete(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/alerting/v3/destinations/pagerduty`, options);
    }
    /**
     * Get a list of all configured PagerDuty services.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/alerting/v3/destinations/pagerduty`, PagerdutiesSinglePage, options);
    }
    /**
     * Links PagerDuty with the account using the integration token.
     */
    link(tokenId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/alerting/v3/destinations/pagerduty/connect/${tokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class PagerdutiesSinglePage extends SinglePage {
}
PagerdutyResource.PagerdutiesSinglePage = PagerdutiesSinglePage;
//# sourceMappingURL=pagerduty.mjs.map