"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebhooksSinglePage = exports.Webhooks = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Webhooks extends resource_1.APIResource {
    /**
     * Creates a new webhook destination.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/alerting/v3/destinations/webhooks`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a webhook destination.
     */
    update(webhookId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/alerting/v3/destinations/webhooks/${webhookId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets a list of all configured webhook destinations.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/alerting/v3/destinations/webhooks`, WebhooksSinglePage, options);
    }
    /**
     * Delete a configured webhook destination.
     */
    delete(webhookId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/alerting/v3/destinations/webhooks/${webhookId}`, options);
    }
    /**
     * Get details for a single webhooks destination.
     */
    get(webhookId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/alerting/v3/destinations/webhooks/${webhookId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Webhooks = Webhooks;
class WebhooksSinglePage extends pagination_1.SinglePage {
}
exports.WebhooksSinglePage = WebhooksSinglePage;
Webhooks.WebhooksSinglePage = WebhooksSinglePage;
//# sourceMappingURL=webhooks.js.map