"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.PoliciesSinglePage = exports.Policies = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Policies extends resource_1.APIResource {
    /**
     * Creates a new Notification policy.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/alerting/v3/policies`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Notification policy.
     */
    update(policyId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/alerting/v3/policies/${policyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a list of all Notification policies.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/alerting/v3/policies`, PoliciesSinglePage, options);
    }
    /**
     * Delete a Notification policy.
     */
    delete(policyId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/alerting/v3/policies/${policyId}`, options);
    }
    /**
     * Get details for a single policy.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/alerting/v3/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Policies = Policies;
class PoliciesSinglePage extends pagination_1.SinglePage {
}
exports.PoliciesSinglePage = PoliciesSinglePage;
Policies.PoliciesSinglePage = PoliciesSinglePage;
//# sourceMappingURL=policies.js.map