// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Policies extends APIResource {
    /**
     * Creates a new Notification policy.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/alerting/v3/policies`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Notification policy.
     */
    update(policyId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/alerting/v3/policies/${policyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a list of all Notification policies.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/alerting/v3/policies`, PoliciesSinglePage, options);
    }
    /**
     * Delete a Notification policy.
     */
    delete(policyId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/alerting/v3/policies/${policyId}`, options);
    }
    /**
     * Get details for a single policy.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/alerting/v3/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class PoliciesSinglePage extends SinglePage {
}
Policies.PoliciesSinglePage = PoliciesSinglePage;
//# sourceMappingURL=policies.mjs.map