import { APIResource } from "../../resource.js";
import * as ConfigurationsAPI from "./configurations.js";
import { Configuration, ConfigurationGetParams, ConfigurationUpdateParams, ConfigurationUpdateResponse, Configurations } from "./configurations.js";
import * as SchemasAPI from "./schemas.js";
import { SchemaListParams, SchemaListResponse, Schemas } from "./schemas.js";
import * as DiscoveryAPI from "./discovery/discovery.js";
import { Discovery, DiscoveryGetParams, DiscoveryGetResponse, DiscoveryOperation } from "./discovery/discovery.js";
import * as ExpressionTemplateAPI from "./expression-template/expression-template.js";
import { ExpressionTemplate } from "./expression-template/expression-template.js";
import * as OperationsAPI from "./operations/operations.js";
import { APIShield, OperationBulkCreateParams, OperationBulkCreateResponse, OperationBulkCreateResponsesSinglePage, OperationBulkDeleteParams, OperationBulkDeleteResponse, OperationCreateParams, OperationCreateResponse, OperationDeleteParams, OperationDeleteResponse, OperationGetParams, OperationGetResponse, OperationListParams, OperationListResponse, OperationListResponsesV4PagePaginationArray, Operations } from "./operations/operations.js";
import * as SettingsAPI from "./settings/settings.js";
import { Settings } from "./settings/settings.js";
import * as UserSchemasAPI from "./user-schemas/user-schemas.js";
import { Message, PublicSchema, PublicSchemasV4PagePaginationArray, SchemaUpload, UserSchemaCreateParams, UserSchemaDeleteParams, UserSchemaDeleteResponse, UserSchemaEditParams, UserSchemaGetParams, UserSchemaListParams, UserSchemas } from "./user-schemas/user-schemas.js";
export declare class APIGateway extends APIResource {
    configurations: ConfigurationsAPI.Configurations;
    discovery: DiscoveryAPI.Discovery;
    operations: OperationsAPI.Operations;
    schemas: SchemasAPI.Schemas;
    settings: SettingsAPI.Settings;
    userSchemas: UserSchemasAPI.UserSchemas;
    expressionTemplate: ExpressionTemplateAPI.ExpressionTemplate;
}
export declare namespace APIGateway {
    export { Configurations as Configurations, type Configuration as Configuration, type ConfigurationUpdateResponse as ConfigurationUpdateResponse, type ConfigurationUpdateParams as ConfigurationUpdateParams, type ConfigurationGetParams as ConfigurationGetParams, };
    export { Discovery as Discovery, type DiscoveryOperation as DiscoveryOperation, type DiscoveryGetResponse as DiscoveryGetResponse, type DiscoveryGetParams as DiscoveryGetParams, };
    export { Operations as Operations, type APIShield as APIShield, type OperationCreateResponse as OperationCreateResponse, type OperationListResponse as OperationListResponse, type OperationDeleteResponse as OperationDeleteResponse, type OperationBulkCreateResponse as OperationBulkCreateResponse, type OperationBulkDeleteResponse as OperationBulkDeleteResponse, type OperationGetResponse as OperationGetResponse, OperationListResponsesV4PagePaginationArray as OperationListResponsesV4PagePaginationArray, OperationBulkCreateResponsesSinglePage as OperationBulkCreateResponsesSinglePage, type OperationCreateParams as OperationCreateParams, type OperationListParams as OperationListParams, type OperationDeleteParams as OperationDeleteParams, type OperationBulkCreateParams as OperationBulkCreateParams, type OperationBulkDeleteParams as OperationBulkDeleteParams, type OperationGetParams as OperationGetParams, };
    export { Schemas as Schemas, type SchemaListResponse as SchemaListResponse, type SchemaListParams as SchemaListParams, };
    export { type Settings as Settings };
    export { UserSchemas as UserSchemas, type Message as Message, type PublicSchema as PublicSchema, type SchemaUpload as SchemaUpload, type UserSchemaDeleteResponse as UserSchemaDeleteResponse, PublicSchemasV4PagePaginationArray as PublicSchemasV4PagePaginationArray, type UserSchemaCreateParams as UserSchemaCreateParams, type UserSchemaListParams as UserSchemaListParams, type UserSchemaDeleteParams as UserSchemaDeleteParams, type UserSchemaEditParams as UserSchemaEditParams, type UserSchemaGetParams as UserSchemaGetParams, };
    export { ExpressionTemplate as ExpressionTemplate };
}
//# sourceMappingURL=api-gateway.d.ts.map