"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiscoveryOperationsV4PagePaginationArray = exports.Operations = void 0;
const resource_1 = require("../../../resource.js");
const discovery_1 = require("./discovery.js");
Object.defineProperty(exports, "DiscoveryOperationsV4PagePaginationArray", { enumerable: true, get: function () { return discovery_1.DiscoveryOperationsV4PagePaginationArray; } });
class Operations extends resource_1.APIResource {
    /**
     * Retrieve the most up to date view of discovered operations
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/api_gateway/discovery/operations`, discovery_1.DiscoveryOperationsV4PagePaginationArray, { query, ...options });
    }
    /**
     * Update the `state` on one or more discovered operations
     */
    bulkEdit(params, options) {
        const { zone_id, body } = params;
        return this._client.patch(`/zones/${zone_id}/api_gateway/discovery/operations`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update the `state` on a discovered operation
     */
    edit(operationId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/api_gateway/discovery/operations/${operationId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Operations = Operations;
//# sourceMappingURL=operations.js.map