// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { DiscoveryOperationsV4PagePaginationArray } from "./discovery.mjs";
export class Operations extends APIResource {
    /**
     * Retrieve the most up to date view of discovered operations
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/api_gateway/discovery/operations`, DiscoveryOperationsV4PagePaginationArray, { query, ...options });
    }
    /**
     * Update the `state` on one or more discovered operations
     */
    bulkEdit(params, options) {
        const { zone_id, body } = params;
        return this._client.patch(`/zones/${zone_id}/api_gateway/discovery/operations`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update the `state` on a discovered operation
     */
    edit(operationId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/api_gateway/discovery/operations/${operationId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
export { DiscoveryOperationsV4PagePaginationArray };
//# sourceMappingURL=operations.mjs.map