// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as SchemaValidationAPI from "./schema-validation.mjs";
import { SchemaValidation, } from "./schema-validation.mjs";
import { SinglePage, V4PagePaginationArray } from "../../../pagination.mjs";
export class Operations extends APIResource {
    constructor() {
        super(...arguments);
        this.schemaValidation = new SchemaValidationAPI.SchemaValidation(this._client);
    }
    /**
     * Add one operation to a zone. Endpoints can contain path variables. Host, method,
     * endpoint will be normalized to a canoncial form when creating an operation and
     * must be unique on the zone. Inserting an operation that matches an existing one
     * will return the record of the already existing operation and update its
     * last_updated date.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/api_gateway/operations/item`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieve information about all operations on a zone
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/api_gateway/operations`, OperationListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete an operation
     */
    delete(operationId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/api_gateway/operations/${operationId}`, options);
    }
    /**
     * Add one or more operations to a zone. Endpoints can contain path variables.
     * Host, method, endpoint will be normalized to a canoncial form when creating an
     * operation and must be unique on the zone. Inserting an operation that matches an
     * existing one will return the record of the already existing operation and update
     * its last_updated date.
     */
    bulkCreate(params, options) {
        const { zone_id, body } = params;
        return this._client.getAPIList(`/zones/${zone_id}/api_gateway/operations`, OperationBulkCreateResponsesSinglePage, { body: body, method: 'post', ...options });
    }
    /**
     * Delete multiple operations
     */
    bulkDelete(params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/api_gateway/operations`, options);
    }
    /**
     * Retrieve information about an operation
     */
    get(operationId, params, options) {
        const { zone_id, ...query } = params;
        return this._client.get(`/zones/${zone_id}/api_gateway/operations/${operationId}`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
export class OperationListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
export class OperationBulkCreateResponsesSinglePage extends SinglePage {
}
Operations.OperationListResponsesV4PagePaginationArray = OperationListResponsesV4PagePaginationArray;
Operations.OperationBulkCreateResponsesSinglePage = OperationBulkCreateResponsesSinglePage;
Operations.SchemaValidation = SchemaValidation;
//# sourceMappingURL=operations.mjs.map