"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmartRouting = void 0;
const resource_1 = require("../../resource.js");
class SmartRouting extends resource_1.APIResource {
    /**
     * Updates enablement of Argo Smart Routing.
     */
    edit(params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/argo/smart_routing`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Argo Smart Routing setting
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/argo/smart_routing`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.SmartRouting = SmartRouting;
//# sourceMappingURL=smart-routing.js.map