"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrandProtection = void 0;
const resource_1 = require("../resource.js");
class BrandProtection extends resource_1.APIResource {
    /**
     * Submit suspicious URL for scanning
     */
    submit(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/brand-protection/submit`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets phishing details about a URL.
     */
    urlInfo(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/brand-protection/url-info`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.BrandProtection = BrandProtection;
//# sourceMappingURL=brand-protection.js.map