// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class RegionalTieredCacheResource extends APIResource {
    /**
     * Instructs Cloudflare to check a regional hub data center on the way to your
     * upper tier. This can help improve performance for smart and custom tiered cache
     * topologies.
     */
    edit(params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/cache/regional_tiered_cache`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Instructs Cloudflare to check a regional hub data center on the way to your
     * upper tier. This can help improve performance for smart and custom tiered cache
     * topologies.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/cache/regional_tiered_cache`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=regional-tiered-cache.mjs.map