import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Variants extends APIResource {
    /**
     * Variant support enables caching variants of images with certain file extensions
     * in addition to the original. This only applies when the origin server sends the
     * 'Vary: Accept' response header. If the origin server sends 'Vary: Accept' but
     * does not serve the variant requested, the response will not be cached. This will
     * be indicated with BYPASS cache status in the response headers.
     */
    delete(params: VariantDeleteParams, options?: Core.RequestOptions): Core.APIPromise<VariantDeleteResponse>;
    /**
     * Variant support enables caching variants of images with certain file extensions
     * in addition to the original. This only applies when the origin server sends the
     * 'Vary: Accept' response header. If the origin server sends 'Vary: Accept' but
     * does not serve the variant requested, the response will not be cached. This will
     * be indicated with BYPASS cache status in the response headers.
     */
    edit(params: VariantEditParams, options?: Core.RequestOptions): Core.APIPromise<VariantEditResponse>;
    /**
     * Variant support enables caching variants of images with certain file extensions
     * in addition to the original. This only applies when the origin server sends the
     * 'Vary: Accept' response header. If the origin server sends 'Vary: Accept' but
     * does not serve the variant requested, the response will not be cached. This will
     * be indicated with BYPASS cache status in the response headers.
     */
    get(params: VariantGetParams, options?: Core.RequestOptions): Core.APIPromise<VariantGetResponse>;
}
/**
 * Variant support enables caching variants of images with certain file extensions
 * in addition to the original. This only applies when the origin server sends the
 * 'Vary: Accept' response header. If the origin server sends 'Vary: Accept' but
 * does not serve the variant requested, the response will not be cached. This will
 * be indicated with BYPASS cache status in the response headers.
 */
export interface CacheVariant {
    /**
     * ID of the zone setting.
     */
    id: 'variants';
    /**
     * Last time this setting was modified.
     */
    modified_on?: string | null;
}
export interface VariantDeleteResponse {
    /**
     * ID of the zone setting.
     */
    id: 'variants';
    /**
     * Whether the setting is editable
     */
    editable: boolean;
    /**
     * Last time this setting was modified.
     */
    modified_on?: string | null;
}
export interface VariantEditResponse {
    /**
     * ID of the zone setting.
     */
    id: 'variants';
    /**
     * Whether the setting is editable
     */
    editable: boolean;
    /**
     * The value of the feature
     */
    value: string;
    /**
     * Last time this setting was modified.
     */
    modified_on?: string | null;
}
export interface VariantGetResponse {
    /**
     * ID of the zone setting.
     */
    id: 'variants';
    /**
     * Whether the setting is editable
     */
    editable: boolean;
    /**
     * The value of the feature
     */
    value: string;
    /**
     * Last time this setting was modified.
     */
    modified_on?: string | null;
}
export interface VariantDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface VariantEditParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: Value of the zone setting.
     */
    value: VariantEditParams.Value;
}
export declare namespace VariantEditParams {
    /**
     * Value of the zone setting.
     */
    interface Value {
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for avif.
         */
        avif?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for bmp.
         */
        bmp?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for gif.
         */
        gif?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for jp2.
         */
        jp2?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for jpeg.
         */
        jpeg?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for jpg.
         */
        jpg?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for jpg2.
         */
        jpg2?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for png.
         */
        png?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for tif.
         */
        tif?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for tiff.
         */
        tiff?: Array<string>;
        /**
         * List of strings with the MIME types of all the variants that should be served
         * for webp.
         */
        webp?: Array<string>;
    }
}
export interface VariantGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Variants {
    export { type CacheVariant as CacheVariant, type VariantDeleteResponse as VariantDeleteResponse, type VariantEditResponse as VariantEditResponse, type VariantGetResponse as VariantGetResponse, type VariantDeleteParams as VariantDeleteParams, type VariantEditParams as VariantEditParams, type VariantGetParams as VariantGetParams, };
}
//# sourceMappingURL=variants.d.ts.map