import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { SinglePage } from "../../pagination.js";
export declare class SFU extends APIResource {
    /**
     * Creates a new Cloudflare calls app. An app is an unique enviroment where each
     * Session can access all Tracks within the app.
     */
    create(params: SFUCreateParams, options?: Core.RequestOptions): Core.APIPromise<SFUCreateResponse>;
    /**
     * Edit details for a single app.
     */
    update(appId: string, params: SFUUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SFUUpdateResponse>;
    /**
     * Lists all apps in the Cloudflare account
     */
    list(params: SFUListParams, options?: Core.RequestOptions): Core.PagePromise<SFUListResponsesSinglePage, SFUListResponse>;
    /**
     * Deletes an app from Cloudflare Calls
     */
    delete(appId: string, params: SFUDeleteParams, options?: Core.RequestOptions): Core.APIPromise<SFUDeleteResponse>;
    /**
     * Fetches details for a single Calls app.
     */
    get(appId: string, params: SFUGetParams, options?: Core.RequestOptions): Core.APIPromise<SFUGetResponse>;
}
export declare class SFUListResponsesSinglePage extends SinglePage<SFUListResponse> {
}
export interface SFUCreateResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * Bearer token
     */
    secret?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface SFUUpdateResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface SFUListResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface SFUDeleteResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface SFUGetResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface SFUCreateParams {
    /**
     * Path param: The account identifier tag.
     */
    account_id: string;
    /**
     * Body param: A short description of Calls app, not shown to end users.
     */
    name?: string;
}
export interface SFUUpdateParams {
    /**
     * Path param: The account identifier tag.
     */
    account_id: string;
    /**
     * Body param: A short description of Calls app, not shown to end users.
     */
    name?: string;
}
export interface SFUListParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export interface SFUDeleteParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export interface SFUGetParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export declare namespace SFU {
    export { type SFUCreateResponse as SFUCreateResponse, type SFUUpdateResponse as SFUUpdateResponse, type SFUListResponse as SFUListResponse, type SFUDeleteResponse as SFUDeleteResponse, type SFUGetResponse as SFUGetResponse, SFUListResponsesSinglePage as SFUListResponsesSinglePage, type SFUCreateParams as SFUCreateParams, type SFUUpdateParams as SFUUpdateParams, type SFUListParams as SFUListParams, type SFUDeleteParams as SFUDeleteParams, type SFUGetParams as SFUGetParams, };
}
//# sourceMappingURL=sfu.d.ts.map