"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SFUListResponsesSinglePage = exports.SFU = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class SFU extends resource_1.APIResource {
    /**
     * Creates a new Cloudflare calls app. An app is an unique enviroment where each
     * Session can access all Tracks within the app.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/calls/apps`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Edit details for a single app.
     */
    update(appId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/calls/apps/${appId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all apps in the Cloudflare account
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/calls/apps`, SFUListResponsesSinglePage, options);
    }
    /**
     * Deletes an app from Cloudflare Calls
     */
    delete(appId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/calls/apps/${appId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches details for a single Calls app.
     */
    get(appId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/calls/apps/${appId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.SFU = SFU;
class SFUListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.SFUListResponsesSinglePage = SFUListResponsesSinglePage;
SFU.SFUListResponsesSinglePage = SFUListResponsesSinglePage;
//# sourceMappingURL=sfu.js.map