// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class SFU extends APIResource {
    /**
     * Creates a new Cloudflare calls app. An app is an unique enviroment where each
     * Session can access all Tracks within the app.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/calls/apps`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Edit details for a single app.
     */
    update(appId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/calls/apps/${appId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all apps in the Cloudflare account
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/calls/apps`, SFUListResponsesSinglePage, options);
    }
    /**
     * Deletes an app from Cloudflare Calls
     */
    delete(appId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/calls/apps/${appId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches details for a single Calls app.
     */
    get(appId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/calls/apps/${appId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class SFUListResponsesSinglePage extends SinglePage {
}
SFU.SFUListResponsesSinglePage = SFUListResponsesSinglePage;
//# sourceMappingURL=sfu.mjs.map