import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { SinglePage } from "../../pagination.js";
export declare class TURN extends APIResource {
    /**
     * Creates a new Cloudflare Calls TURN key.
     */
    create(params: TURNCreateParams, options?: Core.RequestOptions): Core.APIPromise<TURNCreateResponse>;
    /**
     * Edit details for a single TURN key.
     */
    update(keyId: string, params: TURNUpdateParams, options?: Core.RequestOptions): Core.APIPromise<TURNUpdateResponse>;
    /**
     * Lists all TURN keys in the Cloudflare account
     */
    list(params: TURNListParams, options?: Core.RequestOptions): Core.PagePromise<TURNListResponsesSinglePage, TURNListResponse>;
    /**
     * Deletes a TURN key from Cloudflare Calls
     */
    delete(keyId: string, params: TURNDeleteParams, options?: Core.RequestOptions): Core.APIPromise<TURNDeleteResponse>;
    /**
     * Fetches details for a single TURN key.
     */
    get(keyId: string, params: TURNGetParams, options?: Core.RequestOptions): Core.APIPromise<TURNGetResponse>;
}
export declare class TURNListResponsesSinglePage extends SinglePage<TURNListResponse> {
}
export interface TURNCreateResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * Bearer token
     */
    key?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of a TURN key, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface TURNUpdateResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface TURNListResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface TURNDeleteResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface TURNGetResponse {
    /**
     * The date and time the item was created.
     */
    created?: string;
    /**
     * The date and time the item was last modified.
     */
    modified?: string;
    /**
     * A short description of Calls app, not shown to end users.
     */
    name?: string;
    /**
     * A Cloudflare-generated unique identifier for a item.
     */
    uid?: string;
}
export interface TURNCreateParams {
    /**
     * Path param: The account identifier tag.
     */
    account_id: string;
    /**
     * Body param: A short description of a TURN key, not shown to end users.
     */
    name?: string;
}
export interface TURNUpdateParams {
    /**
     * Path param: The account identifier tag.
     */
    account_id: string;
    /**
     * Body param: A short description of a TURN key, not shown to end users.
     */
    name?: string;
}
export interface TURNListParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export interface TURNDeleteParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export interface TURNGetParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export declare namespace TURN {
    export { type TURNCreateResponse as TURNCreateResponse, type TURNUpdateResponse as TURNUpdateResponse, type TURNListResponse as TURNListResponse, type TURNDeleteResponse as TURNDeleteResponse, type TURNGetResponse as TURNGetResponse, TURNListResponsesSinglePage as TURNListResponsesSinglePage, type TURNCreateParams as TURNCreateParams, type TURNUpdateParams as TURNUpdateParams, type TURNListParams as TURNListParams, type TURNDeleteParams as TURNDeleteParams, type TURNGetParams as TURNGetParams, };
}
//# sourceMappingURL=turn.d.ts.map