"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TURNListResponsesSinglePage = exports.TURN = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class TURN extends resource_1.APIResource {
    /**
     * Creates a new Cloudflare Calls TURN key.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/calls/turn_keys`, { body, ...options });
    }
    /**
     * Edit details for a single TURN key.
     */
    update(keyId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/calls/turn_keys/${keyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all TURN keys in the Cloudflare account
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/calls/turn_keys`, TURNListResponsesSinglePage, options);
    }
    /**
     * Deletes a TURN key from Cloudflare Calls
     */
    delete(keyId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/calls/turn_keys/${keyId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches details for a single TURN key.
     */
    get(keyId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/calls/turn_keys/${keyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.TURN = TURN;
class TURNListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.TURNListResponsesSinglePage = TURNListResponsesSinglePage;
TURN.TURNListResponsesSinglePage = TURNListResponsesSinglePage;
//# sourceMappingURL=turn.js.map