"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientCertificatesV4PagePaginationArray = exports.ClientCertificates = void 0;
const resource_1 = require("../resource.js");
const pagination_1 = require("../pagination.js");
class ClientCertificates extends resource_1.APIResource {
    /**
     * Create a new API Shield mTLS Client Certificate
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/client_certificates`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all of your Zone's API Shield mTLS Client Certificates by Status and/or
     * using Pagination
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/client_certificates`, ClientCertificatesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Set a API Shield mTLS Client Certificate to pending_revocation status for
     * processing to revoked status.
     */
    delete(clientCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/client_certificates/${clientCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * If a API Shield mTLS Client Certificate is in a pending_revocation state, you
     * may reactivate it with this endpoint.
     */
    edit(clientCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.patch(`/zones/${zone_id}/client_certificates/${clientCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Details for a single mTLS API Shield Client Certificate
     */
    get(clientCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/client_certificates/${clientCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.ClientCertificates = ClientCertificates;
class ClientCertificatesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.ClientCertificatesV4PagePaginationArray = ClientCertificatesV4PagePaginationArray;
//# sourceMappingURL=client-certificates.js.map