import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as Shared from "../../shared.js";
import { SinglePage } from "../../../pagination.js";
export declare class Assets extends APIResource {
    /**
     * List Request Assets
     */
    create(accountIdentifier: string, requestIdentifier: string, body: AssetCreateParams, options?: Core.RequestOptions): Core.PagePromise<AssetCreateResponsesSinglePage, AssetCreateResponse>;
    /**
     * Update a Request Asset
     */
    update(accountIdentifier: string, requestIdentifier: string, assetIdentifer: string, body: AssetUpdateParams, options?: Core.RequestOptions): Core.APIPromise<AssetUpdateResponse>;
    /**
     * Delete a Request Asset
     */
    delete(accountIdentifier: string, requestIdentifier: string, assetIdentifer: string, options?: Core.RequestOptions): Core.APIPromise<AssetDeleteResponse>;
    /**
     * Get a Request Asset
     */
    get(accountIdentifier: string, requestIdentifier: string, assetIdentifer: string, options?: Core.RequestOptions): Core.PagePromise<AssetGetResponsesSinglePage, AssetGetResponse>;
}
export declare class AssetCreateResponsesSinglePage extends SinglePage<AssetCreateResponse> {
}
export declare class AssetGetResponsesSinglePage extends SinglePage<AssetGetResponse> {
}
export interface AssetCreateResponse {
    /**
     * Asset ID
     */
    id: number;
    /**
     * Asset name
     */
    name: string;
    /**
     * Asset creation time
     */
    created?: string;
    /**
     * Asset description
     */
    description?: string;
    /**
     * Asset file type
     */
    file_type?: string;
}
export interface AssetUpdateResponse {
    /**
     * Asset ID
     */
    id: number;
    /**
     * Asset name
     */
    name: string;
    /**
     * Asset creation time
     */
    created?: string;
    /**
     * Asset description
     */
    description?: string;
    /**
     * Asset file type
     */
    file_type?: string;
}
export interface AssetDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface AssetGetResponse {
    /**
     * Asset ID
     */
    id: number;
    /**
     * Asset name
     */
    name: string;
    /**
     * Asset creation time
     */
    created?: string;
    /**
     * Asset description
     */
    description?: string;
    /**
     * Asset file type
     */
    file_type?: string;
}
export interface AssetCreateParams {
    /**
     * Page number of results
     */
    page: number;
    /**
     * Number of results per page
     */
    per_page: number;
}
export interface AssetUpdateParams {
    /**
     * Asset file to upload
     */
    source?: string;
}
export declare namespace Assets {
    export { type AssetCreateResponse as AssetCreateResponse, type AssetUpdateResponse as AssetUpdateResponse, type AssetDeleteResponse as AssetDeleteResponse, type AssetGetResponse as AssetGetResponse, AssetCreateResponsesSinglePage as AssetCreateResponsesSinglePage, AssetGetResponsesSinglePage as AssetGetResponsesSinglePage, type AssetCreateParams as AssetCreateParams, type AssetUpdateParams as AssetUpdateParams, };
}
//# sourceMappingURL=assets.d.ts.map