"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetGetResponsesSinglePage = exports.AssetCreateResponsesSinglePage = exports.Assets = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Assets extends resource_1.APIResource {
    /**
     * List Request Assets
     */
    create(accountIdentifier, requestIdentifier, body, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset`, AssetCreateResponsesSinglePage, { body, method: 'post', ...options });
    }
    /**
     * Update a Request Asset
     */
    update(accountIdentifier, requestIdentifier, assetIdentifer, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset/${assetIdentifer}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a Request Asset
     */
    delete(accountIdentifier, requestIdentifier, assetIdentifer, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset/${assetIdentifer}`, options);
    }
    /**
     * Get a Request Asset
     */
    get(accountIdentifier, requestIdentifier, assetIdentifer, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset/${assetIdentifer}`, AssetGetResponsesSinglePage, options);
    }
}
exports.Assets = Assets;
class AssetCreateResponsesSinglePage extends pagination_1.SinglePage {
}
exports.AssetCreateResponsesSinglePage = AssetCreateResponsesSinglePage;
class AssetGetResponsesSinglePage extends pagination_1.SinglePage {
}
exports.AssetGetResponsesSinglePage = AssetGetResponsesSinglePage;
Assets.AssetCreateResponsesSinglePage = AssetCreateResponsesSinglePage;
Assets.AssetGetResponsesSinglePage = AssetGetResponsesSinglePage;
//# sourceMappingURL=assets.js.map