// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Assets extends APIResource {
    /**
     * List Request Assets
     */
    create(accountIdentifier, requestIdentifier, body, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset`, AssetCreateResponsesSinglePage, { body, method: 'post', ...options });
    }
    /**
     * Update a Request Asset
     */
    update(accountIdentifier, requestIdentifier, assetIdentifer, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset/${assetIdentifer}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a Request Asset
     */
    delete(accountIdentifier, requestIdentifier, assetIdentifer, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset/${assetIdentifer}`, options);
    }
    /**
     * Get a Request Asset
     */
    get(accountIdentifier, requestIdentifier, assetIdentifer, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/asset/${assetIdentifer}`, AssetGetResponsesSinglePage, options);
    }
}
export class AssetCreateResponsesSinglePage extends SinglePage {
}
export class AssetGetResponsesSinglePage extends SinglePage {
}
Assets.AssetCreateResponsesSinglePage = AssetCreateResponsesSinglePage;
Assets.AssetGetResponsesSinglePage = AssetGetResponsesSinglePage;
//# sourceMappingURL=assets.mjs.map