"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagesSinglePage = exports.MessageResource = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class MessageResource extends resource_1.APIResource {
    /**
     * Create a New Request Message
     */
    create(accountIdentifier, requestIdentifier, body, options) {
        return this._client.post(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message/new`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Request Message
     */
    update(accountIdentifier, requestIdentifier, messageIdentifer, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message/${messageIdentifer}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a Request Message
     */
    delete(accountIdentifier, requestIdentifier, messageIdentifer, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message/${messageIdentifer}`, options);
    }
    /**
     * List Request Messages
     */
    get(accountIdentifier, requestIdentifier, body, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message`, MessagesSinglePage, { body, method: 'post', ...options });
    }
}
exports.MessageResource = MessageResource;
class MessagesSinglePage extends pagination_1.SinglePage {
}
exports.MessagesSinglePage = MessagesSinglePage;
MessageResource.MessagesSinglePage = MessagesSinglePage;
//# sourceMappingURL=message.js.map