// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class MessageResource extends APIResource {
    /**
     * Create a New Request Message
     */
    create(accountIdentifier, requestIdentifier, body, options) {
        return this._client.post(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message/new`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Request Message
     */
    update(accountIdentifier, requestIdentifier, messageIdentifer, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message/${messageIdentifer}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a Request Message
     */
    delete(accountIdentifier, requestIdentifier, messageIdentifer, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message/${messageIdentifer}`, options);
    }
    /**
     * List Request Messages
     */
    get(accountIdentifier, requestIdentifier, body, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}/message`, MessagesSinglePage, { body, method: 'post', ...options });
    }
}
export class MessagesSinglePage extends SinglePage {
}
MessageResource.MessagesSinglePage = MessagesSinglePage;
//# sourceMappingURL=message.mjs.map